/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal.markers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.sonarlint.eclipse.core.internal.PreferencesUtils;
import org.sonarlint.eclipse.core.internal.SonarLintCorePlugin;

public final class MarkerUtils {
    public static final String SONAR_MARKER_RULE_KEY_ATTR = "rulekey";
    public static final String SONAR_MARKER_RULE_NAME_ATTR = "rulename";
    public static final String SONAR_MARKER_ISSUE_SEVERITY_ATTR = "sonarseverity";
    public static final String SONAR_MARKER_CREATION_DATE_ATTR = "creationdate";
    public static final String SONAR_MARKER_CHECKSUM_ATTR = "checksum";

    private MarkerUtils() {
    }

    public static void deleteIssuesMarkers(IResource resource) {
        try {
            resource.deleteMarkers("org.sonarlint.eclipse.core.sonarlintProblem", true, 2);
        }
        catch (CoreException e) {
            SonarLintCorePlugin.getDefault().error(e.getMessage(), e);
        }
    }

    public static List<IMarker> findMarkers(IResource resource) {
        try {
            return Arrays.asList(resource.findMarkers("org.sonarlint.eclipse.core.sonarlintProblem", true, 2));
        }
        catch (CoreException e) {
            SonarLintCorePlugin.getDefault().error(e.getMessage(), e);
            return Collections.emptyList();
        }
    }

    public static void updateAllSonarMarkerSeverity() throws CoreException {
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isAccessible()) {
                IMarker[] iMarkerArray = project.findMarkers("org.sonarlint.eclipse.core.sonarlintProblem", true, 2);
                int n3 = iMarkerArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMarker marker = iMarkerArray[n4];
                    marker.setAttribute("severity", PreferencesUtils.getMarkerSeverity());
                    ++n4;
                }
            }
            ++n2;
        }
    }
}

